﻿cls
$String = "128-Bit"
$Domain = "dwp.local"
$DC = Get-ADDomain | Select-Object PDCEmulator -expandproperty  PDCEmulator
$GPOs = Get-GPO -All -Domain $Domain -Server $DC | sort DisplayName

Foreach ($GPO in $GPOs)  {
  
  Write-Host "Working on $($GPO.DisplayName)"
  
  $CurrentGPOReport = Get-GPOReport -Guid $GPO.Id -ReportType Xml -Domain $Domain -Server $DC
  
  If ($CurrentGPOReport -match $String)  {
	Write-Host "A Group Policy matching ""$($String)"" has been found:" -Foregroundcolor Green
	Write-Host "-  GPO Name: $($GPO.DisplayName)" -Foregroundcolor Green
	Write-Host "-  GPO Id: $($GPO.Id)" -Foregroundcolor Green
	Write-Host "-  GPO Status: $($GPO.GpoStatus)" -Foregroundcolor Green
  }
  
}